clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1011.dta, clear

*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

keep if smpl2==1

cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

foreach var in turnmig_rate ///
			share_age_0_24 share_age_55plus  ///
			WVS_index_2 ///
			{
			if "`var'"=="turnmig_rate" {
				local str0="Migration"
				local str1A="Raw"
				local str1B="Partial out FE"				
				local str1C="Partial out controls"
				local str1D="Partial out controls & FE"
				
			}
			if "`var'"=="share_age_0_24" {
				local str0="Population share of 0-24 years old"
				local str1A=" "
				local str1B=" "
				local str1C=" "			
				local str1D=" "	
			}
			if "`var'"=="share_age_55plus" {
				local str0="Population share of 55+ years old"
				local str1A=" "
				local str1B=" "
				local str1C=" "	
				local str1D=" "	
				
			}
			if "`var'"=="WVS_index_2" {
				local str0="Trust"
				local str1A=" "
				local str1B=" "
				local str1C=" "		
				local str1D=" "	
				
			}

			
			twoway ///
				(scatter ue2_hyst `var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter ue2_hyst `var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter ue2_hyst `var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter ue2_hyst `var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter ue2_hyst `var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter ue2_hyst `var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("`str1A'")	///
				 title("") ///
				 saving(raw_`var'.gph, replace)
				 
				 
			
			reg ue2_hyst cid_* [aw=pop_wgt] if smpl2==1
			capture drop resFE_ue2_hyst
			predict resFE_ue2_hyst if e(sample), resid
			
			reg `var' cid_* [aw=pop_wgt] if smpl2==1
			capture drop resFE_`var'
			predict resFE_`var' if e(sample), resid
			
			
			
			twoway ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter resFE_ue2_hyst resFE_`var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter resFE_ue2_hyst resFE_`var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("`str1B'")	///
				title("") ///				 
				 saving(residFE_`var'.gph, replace)
				 
				
				
			reg ue2_hyst ///
				year_school ///		
				share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
				hh_size home_own_rate ///		
				netmig_rate urban_share_500_y1990 ///
				logY_ppp mlog_road_density city_nuts capital ///
				[aw=pop_wgt] if smpl2==1
			capture drop res_ue2_hyst
			predict res_ue2_hyst if e(sample), resid
			
			reg `var'  ///
				year_school ///		
				share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
				hh_size home_own_rate ///		
				netmig_rate urban_share_500_y1990 ///
				logY_ppp mlog_road_density city_nuts capital ///
				[aw=pop_wgt] if smpl2==1
			capture drop res_`var'
			predict res_`var' if e(sample), resid
			
			
			
			twoway ///
				(scatter res_ue2_hyst res_`var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter res_ue2_hyst res_`var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter res_ue2_hyst res_`var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter res_ue2_hyst res_`var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter res_ue2_hyst res_`var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("`str1C'")	///
				title("") ///				 				 
				 saving(resid_`var'.gph, replace)
				 
				 
				 
			*** Controls & FE	 
			reg ue2_hyst ///
				year_school ///		
				share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
				hh_size home_own_rate ///		
				netmig_rate urban_share_500_y1990 ///
				logY_ppp mlog_road_density city_nuts capital ///
				cid_* [aw=pop_wgt] if smpl2==1
			capture drop res_ue2_hyst
			predict res_ue2_hyst if e(sample), resid
			
			reg `var'  ///
				year_school ///		
				share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  ///
				hh_size home_own_rate ///		
				netmig_rate urban_share_500_y1990 ///
				logY_ppp mlog_road_density city_nuts capital ///
				cid_* [aw=pop_wgt] if smpl2==1
			capture drop res_`var'
			predict res_`var' if e(sample), resid
			
			
			
			twoway ///
				(scatter res_ue2_hyst res_`var' if country=="US", msymbol(o) mcolor(black) mfcolor(black)) ///
				(scatter res_ue2_hyst res_`var' if country=="UK", msymbol(o) mcolor(red) mfcolor(red)) ///
				(scatter res_ue2_hyst res_`var' if country=="CA", msymbol(o) mcolor(blue) mfcolor(blue)) ///
				(scatter res_ue2_hyst res_`var' if country=="DE", msymbol(+) mcolor(blue) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="AT", msymbol(+) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="CH", msymbol(+) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="BE", msymbol(+) mcolor(green) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="NL", msymbol(+) mcolor(pink) mfcolor(none)) ///		
				(scatter res_ue2_hyst res_`var' if country=="FR", msymbol(Oh) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="IT", msymbol(Sh) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="ES", msymbol(Oh) mcolor(blue) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="SE", msymbol(Th) mcolor(black) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="FI", msymbol(Th) mcolor(red) mfcolor(none)) ///
				(scatter res_ue2_hyst res_`var' if country=="DK", msymbol(Th) mcolor(blue) mfcolor(none)) ///
				, legend(off) ///
				 xtitle("`str0'") ytitle("`str1D'")	///
				title("") ///				 				 
				 saving(residFEC_`var'.gph, replace)				 
				
			}
			
	
graph combine ///
	raw_turnmig_rate.gph 	 	raw_share_age_0_24.gph  		raw_share_age_55plus.gph 		raw_WVS_index_2.gph ///
	resid_turnmig_rate.gph 	 	resid_share_age_0_24.gph 		resid_share_age_55plus.gph 		resid_WVS_index_2.gph ///
	residFEC_turnmig_rate.gph 	residFEC_share_age_0_24.gph 	residFEC_share_age_55plus.gph 	residFEC_WVS_index_2.gph ///	
	, imargin(tiny)
	
